import type { NextConfig } from "next";

// All supported career domains from CareerDomainEnum
const CAREER_DOMAINS = [
  "apply-link.net",
  "apply-jobs.net",
  "bewerben.link",
  "appliquer.net",
  "postular.link",
  "solliciteren.link",
  "candidarsi.link",
];

const nextConfig: NextConfig = {
  images: {
    remotePatterns: [
      {
        protocol: "http",
        hostname: "127.0.0.1",
        port: "8000",
        pathname: "/**",
      },
      {
        protocol: "https",
        hostname: "app.flowxtra.com",
        pathname: "/**",
      },
      {
        protocol: "https",
        hostname: "*.flowxtra.com",
        pathname: "/**",
      },
      // Support all career domains
      ...CAREER_DOMAINS.map((domain) => ({
        protocol: "https" as const,
        hostname: `*.${domain}`,
        pathname: "/**",
      })),
    ],
    unoptimized: true, // Allow unoptimized images for external URLs
  },
  // Ensure root path is handled correctly
  async rewrites() {
    return [];
  },
};

export default nextConfig;
