// Type definitions for Profile page

export interface Company {
  id: number;
  name: string;
  logo: string | null;
  description: string | null;
  mission: string | null;
  number_employees: number | null;
  company_type: {
    id: number;
    name: string;
  } | null;
  website: string | null;
  show_website: boolean;
  company_image_gallery: Array<{
    imge: string;
  }> | null;
  company_show_social: CompanyShowSocial | null;
  benefits_company:
    | Array<{
        id: number;
        name: string;
      }>
    | [];
  company_value:
    | Array<{
        id: number;
        name: string;
      }>
    | [];
}

export interface CompanyShowSocial {
  id: number;
  company_id: string;
  logo: boolean;
  location: boolean;
  employment_type: boolean;
  category: boolean;
  salary: boolean;
  show_name_company: boolean;
  show_num_emloyees: boolean;
  show_category_company: boolean;
  show_about_company: boolean;
  category_filter: boolean;
  location_filter: boolean;
  employment_type_filter: boolean;
  department_filter: boolean;
  show_job_workplace: boolean;
  show_date_job: boolean;
  show_media: boolean;
  show_values: boolean;
  show_benfits: boolean;
}

export interface Job {
  id: number;
  hash_id: string;
  title: string;
  workplace: string;
  created_at: string;
  salary: string | null;
  min_salary: number | null;
  max_salary: number | null;
  currency: string;
  rate_salary: string;
  salry_pay_by: "range" | "fixed";
  company_job_category: {
    id: number;
    name: string;
  } | null;
  job_type_job: Array<{
    id: number;
    job_type: {
      id: number;
      name: string;
    };
  }>;
  company_office: {
    id: number;
    country: {
      id: number;
      name: string;
    };
    state: {
      id: number;
      name: string;
    };
  };
}

export interface FilterData {
  company_show_department: Array<{
    id: number;
    name: string;
  }>;
  emplement_types: Array<{
    id: number;
    name: string;
  }>;
  locations: Array<{
    id: number;
    name: string;
  }>;
  ams_catrgories: Array<{
    id: number;
    name: string;
  }>;
}

export interface ProfileData {
  profile: Company;
  jobs: {
    data: Job[];
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
  };
}

export interface FilterObj {
  catrgory_id?: string | null;
  employment_type_id?: string | null;
  department_id?: string | null;
  location_id?: string | null;
}

// Brand Kit Types
export interface TypographySettings {
  headings?: {
    family?: string;
    weight?: string;
  };
  headings_family?: string;
  headings_weight?: string;
  body?: {
    family?: string;
    baseSize?: number;
    weight?: string;
  };
  body_family?: string;
  body_base_size?: number;
  body_weight?: string;
}

export interface LogoSetting {
  type?: "image" | "text";
  imageUrl?: string;
  image_url?: string;
  text?: string;
  fontFamily?: string;
  font_family?: string;
  fontSize?: number;
  font_size?: number;
  color?: string;
  linkUrl?: string;
  link_url?: string;
  linkTarget?: string;
  link_target?: string;
}

export interface LogoSettings {
  header?: LogoSetting;
  footer?: LogoSetting;
  favicon?: LogoSetting;
  // Flat snake_case format
  header_logo_url?: string;
  header_logo_type?: string;
  header_text?: string;
  header_font_family?: string;
  header_font_size?: number;
  header_color?: string;
  header_link_url?: string;
  header_link_target?: string;
  footer_logo_url?: string;
  footer_logo_type?: string;
  footer_text?: string;
  footer_font_family?: string;
  footer_font_size?: number;
  footer_color?: string;
  footer_link_url?: string;
  footer_link_target?: string;
  favicon_url?: string;
}

export interface FooterSettings {
  customText?: string;
  custom_text?: string;
  showTerms?: boolean;
  show_terms?: boolean;
  showPrivacy?: boolean;
  show_privacy?: boolean;
  showReport?: boolean;
  show_report?: boolean;
  showAccessibility?: boolean;
  show_accessibility?: boolean;
  showSitemap?: boolean;
  show_sitemap?: boolean;
  showBranding?: boolean;
  show_branding?: boolean;
}

export interface SocialLink {
  id?: number;
  platform?: string;
  platform_id?: string;
  url?: string;
  link_url?: string;
  customName?: string;
  custom_name?: string;
  customIcon?: string;
  custom_icon?: string;
}

export interface SocialStyling {
  shape?: "circle" | "rounded" | "square";
  size?: number;
  spacing?: number;
  colorMode?: "platform" | "mono" | "white" | "grey" | "custom";
  color_mode?: string;
  customColor?: string;
  custom_color?: string;
  background?: "none" | "filled" | "outlined" | "custom";
  customBgColor?: string;
  custom_bg_color?: string;
  hoverEffect?: "lift" | "scale" | "glow" | "none";
  hover_effect?: string;
}

// Extended Company interface with Brand Kit
export interface CompanyWithBrandKit extends Company {
  typography_settings?: TypographySettings;
  logo_settings?: LogoSettings;
  logo_setting?: LogoSettings;
  footer_settings?: FooterSettings;
  social_links?: SocialLink[];
  social_styling?: SocialStyling;
}
