"use client";

import { useEffect, useRef } from "react";

export default function FontAwesome() {
  const linkRef = useRef<HTMLLinkElement | null>(null);

  useEffect(() => {
    if (typeof window === "undefined") return;

    // Check if FontAwesome is already loaded
    const existingLink = document.querySelector('link[href*="font-awesome"]');
    if (existingLink) {
      return;
    }

    const link = document.createElement("link");
    link.rel = "stylesheet";
    link.href = "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css";
    link.integrity = "sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==";
    link.crossOrigin = "anonymous";
    link.setAttribute("referrerpolicy", "no-referrer");
    document.head.appendChild(link);
    linkRef.current = link;

    return () => {
      // Don't remove in cleanup - this component is in layout.tsx and should persist across page navigations
      // The link will remain in the DOM for the entire app lifecycle
    };
  }, []);

  return null;
}

