"use client";

import { useEffect, useRef } from "react";

export default function BootstrapIcons() {
  const linkRef = useRef<HTMLLinkElement | null>(null);

  useEffect(() => {
    if (typeof window === "undefined") return;

    // Check if Bootstrap Icons is already loaded
    const existingLink = document.querySelector('link[href*="bootstrap-icons"]');
    if (existingLink) {
      return;
    }

    const link = document.createElement("link");
    link.rel = "stylesheet";
    link.href = "https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css";
    link.crossOrigin = "anonymous";
    document.head.appendChild(link);
    linkRef.current = link;

    return () => {
      // Don't remove in cleanup - this component is in layout.tsx and should persist across page navigations
      // The link will remain in the DOM for the entire app lifecycle
    };
  }, []);

  return null;
}

