# Company Jobs Page - Next.js

This is a Next.js project for displaying company profiles and job listings.

## Features

- **Company Profile Page** (`/profile`)
  - Display company information (logo, name, description, mission)
  - Show available job positions with pagination
  - Filter jobs by employment type, department, and location
  - Display company benefits, values, and media gallery
  - SEO optimized with dynamic metadata

## Getting Started

### Installation

```bash
npm install
```

### Environment Variables

Create a `.env.local` file:

```env
NEXT_PUBLIC_API_BASE_URL=http://127.0.0.1:8000/api
```

### Run Development Server

```bash
npm run dev
```

Open [http://localhost:3000](http://localhost:3000) in your browser.

## Project Structure

```
company-jobs-page/
├── app/
│   ├── profile/
│   │   ├── page.tsx          # Profile page component
│   │   ├── layout.tsx        # Profile layout with metadata
│   │   └── metadata.ts       # Dynamic metadata generation
│   ├── globals.css           # Global styles
│   └── layout.tsx            # Root layout
├── lib/
│   ├── api.ts                # API utilities
│   ├── types.ts              # TypeScript type definitions
│   └── utils.ts              # Utility functions
└── public/                   # Static assets
```

## API Endpoints

- `GET /companies/show_share` - Get company profile and jobs
- `GET /companies/createProfilFilter` - Get filter options

## Technologies Used

- Next.js 16
- React 19
- TypeScript
- Tailwind CSS
- Bootstrap Icons
